"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StandardDeviationAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_text_handler = require("../lib/create_text_handler");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RESTRICT_FIELDS = _public.KBN_FIELD_TYPES.NUMBER;
const StandardDeviationAggUi = props => {
  const {
    series,
    panel,
    fields,
    intl
  } = props;
  const defaults = {
    sigma: ''
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const modeOptions = [{
    label: intl.formatMessage({
      id: 'visTypeTimeseries.stdDeviation.modeOptions.rawLabel',
      defaultMessage: 'Raw'
    }),
    value: 'raw'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.stdDeviation.modeOptions.upperBoundLabel',
      defaultMessage: 'Upper Bound'
    }),
    value: 'upper'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.stdDeviation.modeOptions.lowerBoundLabel',
      defaultMessage: 'Lower Bound'
    }),
    value: 'lower'
  }];
  if (panel.type !== 'table') {
    modeOptions.push({
      label: intl.formatMessage({
        id: 'visTypeTimeseries.stdDeviation.modeOptions.boundsBandLabel',
        defaultMessage: 'Bounds Band'
      }),
      value: 'band'
    });
  }
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleTextChange = (0, _create_text_handler.createTextHandler)(handleChange);
  const indexPattern = series.override_index_pattern ? series.series_index_pattern : panel.index_pattern;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const selectedModeOption = modeOptions.find(option => {
    return model.mode === option.value;
  });
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.stdDeviation.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.stdDeviation.fieldLabel",
      defaultMessage: "Field"
    }),
    fields: fields,
    type: model.type,
    restrict: RESTRICT_FIELDS,
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('sigma'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.stdDeviation.sigmaLabel",
      defaultMessage: "Sigma"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: model.sigma,
    onChange: handleTextChange('sigma')
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('mode'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.stdDeviation.modeLabel",
      defaultMessage: "Mode"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: modeOptions,
    selectedOptions: selectedModeOption ? [selectedModeOption] : [],
    onChange: handleSelectChange('mode'),
    singleSelection: {
      asPlainText: true
    }
  })))));
};
StandardDeviationAggUi.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};
const StandardDeviationAgg = (0, _i18nReact.injectI18n)(StandardDeviationAggUi);
exports.StandardDeviationAgg = StandardDeviationAgg;