"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileAgg = PercentileAgg;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_number_handler = require("../lib/create_number_handler");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _percentile_ui = require("./percentile_ui");
var _percentile_hdr = require("./percentile_hdr");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RESTRICT_FIELDS = [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.HISTOGRAM];
const checkModel = model => Array.isArray(model.percentiles);
function PercentileAgg(props) {
  const {
    series,
    model,
    panel,
    fields
  } = props;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(handleChange);
  const indexPattern = series.override_index_pattern ? series.series_index_pattern : panel.index_pattern;
  (0, _react.useEffect)(() => {
    if (!checkModel(model)) {
      handleChange({
        percentiles: [(0, _percentile_ui.newPercentile)({
          value: 50
        })]
      });
    }
  }, [handleChange, model]);
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "s",
    columns: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.percentile.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.percentile.fieldLabel",
      defaultMessage: "Field"
    }),
    fields: fields,
    type: model.type,
    restrict: RESTRICT_FIELDS,
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.percentile.percents",
      defaultMessage: "Percents"
    })
  }, /*#__PURE__*/_react.default.createElement(_percentile_ui.Percentiles, {
    onChange: handleChange,
    name: "percentiles",
    model: model,
    panel: panel,
    seriesId: series.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_percentile_hdr.PercentileHdr, {
    value: model.numberOfSignificantValueDigits,
    onChange: handleNumberChange('numberOfSignificantValueDigits')
  }))));
}
PercentileAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};