"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiFieldSelect = MultiFieldSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DROPPABLE_ID = 'onDragEnd';
const dragAriaLabel = _i18n.i18n.translate('visTypeTimeseries.fieldSelect.dragAriaLabel', {
  defaultMessage: 'Drag field'
});
function MultiFieldSelect(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: props.onDragEnd
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: DROPPABLE_ID,
    spacing: "none"
  }, props.values.map((value, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    spacing: "m",
    key: index,
    index: index,
    draggableId: `${index}`,
    customDragHandle: true
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "s"
  }, provided.dragHandleProps, {
    "aria-label": dragAriaLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(props.WrappedComponent, {
    value: value,
    index: index
  })))))));
}