"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Aggs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _agg = require("./agg");
var _collection_actions = require("../lib/collection_actions");
var _new_metric_agg_fn = require("../lib/new_metric_agg_fn");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

const DROPPABLE_ID = 'aggs_dnd';
class Aggs extends _react.PureComponent {
  render() {
    const {
      panel,
      model,
      fields,
      name,
      uiRestrictions,
      onChange
    } = this.props;
    const list = model.metrics;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: `${DROPPABLE_ID}:${model.id}`,
      type: "MICRO",
      spacing: "s"
    }, list.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "s",
      key: row.id,
      index: idx,
      customDragHandle: true,
      draggableId: `${DROPPABLE_ID}:${model.id}:${row.id}`
    }, provided => /*#__PURE__*/_react.default.createElement(_agg.Agg, {
      key: row.id,
      disableDelete: list.length < 2,
      fields: fields,
      name: name,
      model: row,
      onAdd: () => (0, _collection_actions.handleAdd)(this.props, _new_metric_agg_fn.newMetricAggFn),
      onModelChange: onChange,
      onDelete: () => (0, _collection_actions.handleDelete)(this.props, row),
      panel: panel,
      series: model,
      siblings: list,
      uiRestrictions: uiRestrictions,
      dragHandleProps: provided.dragHandleProps
    }))));
  }
}
exports.Aggs = Aggs;