"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelionVisPlugin = void 0;
var _timelion_vis_fn = require("./timelion_vis_fn");
var _timelion_vis_type = require("./timelion_vis_type");
var _plugin_services = require("./helpers/plugin_services");
var _arg_value_suggestions = require("./helpers/arg_value_suggestions");
var _timelion_vis_renderer = require("./timelion_vis_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class TimelionVisPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup({
    uiSettings,
    http,
    theme
  }, {
    expressions,
    visualizations,
    data,
    charts
  }) {
    const dependencies = {
      http,
      uiSettings,
      timefilter: data.query.timefilter.timefilter,
      theme
    };
    expressions.registerFunction(() => (0, _timelion_vis_fn.getTimelionVisualizationConfig)(dependencies));
    expressions.registerRenderer((0, _timelion_vis_renderer.getTimelionVisRenderer)(dependencies));
    visualizations.createBaseVisualization((0, _timelion_vis_type.getTimelionVisDefinition)(dependencies));
  }
  start(core, {
    data,
    charts,
    dataViews,
    fieldFormats,
    usageCollection
  }) {
    (0, _plugin_services.setIndexPatterns)(dataViews);
    (0, _plugin_services.setDataSearch)(data.search);
    (0, _plugin_services.setCharts)(charts);
    (0, _plugin_services.setFieldFormats)(fieldFormats);
    if (usageCollection) {
      (0, _plugin_services.setUsageCollection)(usageCollection);
    }
    return {
      getArgValueSuggestions: _arg_value_suggestions.getArgValueSuggestions
    };
  }
}
exports.TimelionVisPlugin = TimelionVisPlugin;