"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _common = require("../common");
var _table_vis_options_lazy = require("./components/table_vis_options_lazy");
var _to_ast = require("./to_ast");
var _convert_to_lens = require("./convert_to_lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const tableVisTypeDefinition = {
  name: _common.VIS_TYPE_TABLE,
  title: _i18n.i18n.translate('visTypeTable.tableVisTitle', {
    defaultMessage: 'Data table'
  }),
  icon: 'visTable',
  description: _i18n.i18n.translate('visTypeTable.tableVisDescription', {
    defaultMessage: 'Display data in rows and columns.'
  }),
  getSupportedTriggers: () => {
    return [_public2.VIS_EVENT_TO_TRIGGER.filter];
  },
  visConfig: {
    defaults: {
      perPage: 10,
      showPartialRows: false,
      showMetricsAtAllLevels: false,
      showTotal: false,
      showToolbar: false,
      totalFunc: 'sum',
      percentageCol: '',
      autoFitRowToContent: false
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: _table_vis_options_lazy.TableOptions,
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.metricTitle', {
        defaultMessage: 'Metric'
      }),
      aggFilter: ['!geo_centroid', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      aggSettings: {
        top_hits: {
          allowStrings: true
        }
      },
      min: 1,
      defaults: [{
        type: 'count',
        schema: 'metric'
      }]
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'bucket',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.bucketTitle', {
        defaultMessage: 'Split rows'
      }),
      aggFilter: ['!filter', '!sampler', '!diversified_sampler', '!multi_terms', '!significant_text', '!rare_terms']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'split',
      title: _i18n.i18n.translate('visTypeTable.tableVisEditorConfig.schemas.splitTitle', {
        defaultMessage: 'Split table'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!filter', '!sampler', '!diversified_sampler', '!multi_terms', '!significant_text', '!rare_terms']
    }]
  },
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  hasPartialRows: vis => vis.params.showPartialRows,
  hierarchicalData: vis => vis.params.showPartialRows || vis.params.showMetricsAtAllLevels,
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => vis ? (0, _convert_to_lens.convertToLens)(vis, timefilter) : null,
  getExpressionVariables: async (vis, timeFilter) => {
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await (0, _convert_to_lens.convertToLens)(vis, timeFilter) : null)
    };
  }
};
exports.tableVisTypeDefinition = tableVisTypeDefinition;