"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTableVis = void 0;
var _table_vis_fn = require("./table_vis_fn");
var _table_vis_renderer = require("./table_vis_renderer");
var _table_vis_type = require("./table_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerTableVis = async (core, {
  expressions,
  visualizations
}) => {
  const [coreStart, {
    usageCollection
  }] = await core.getStartServices();
  expressions.registerFunction(_table_vis_fn.createTableVisFn);
  expressions.registerRenderer((0, _table_vis_renderer.getTableVisRenderer)(coreStart, usageCollection));
  visualizations.createBaseVisualization(_table_vis_type.tableVisTypeDefinition);
};
exports.registerTableVis = registerTableVis;