"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisPlugin = void 0;
var _services = require("./services");
var _register_vis = require("./register_vis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class TableVisPlugin {
  setup(core, deps) {
    (0, _register_vis.registerTableVis)(core, deps);
  }
  start(core, {
    fieldFormats,
    dataViews
  }) {
    (0, _services.setFormatService)(fieldFormats);
    (0, _services.setDataViewsStart)(dataViews);
  }
}
exports.TableVisPlugin = TableVisPlugin;