"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.totalAggregations = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const totalAggregations = [{
  value: _common.AggTypes.SUM,
  text: _i18n.i18n.translate('visTypeTable.totalAggregations.sumText', {
    defaultMessage: 'Sum'
  })
}, {
  value: _common.AggTypes.AVG,
  text: _i18n.i18n.translate('visTypeTable.totalAggregations.averageText', {
    defaultMessage: 'Average'
  })
}, {
  value: _common.AggTypes.MIN,
  text: _i18n.i18n.translate('visTypeTable.totalAggregations.minText', {
    defaultMessage: 'Min'
  })
}, {
  value: _common.AggTypes.MAX,
  text: _i18n.i18n.translate('visTypeTable.totalAggregations.maxText', {
    defaultMessage: 'Max'
  })
}, {
  value: _common.AggTypes.COUNT,
  text: _i18n.i18n.translate('visTypeTable.totalAggregations.countText', {
    defaultMessage: 'Count'
  })
}];
exports.totalAggregations = totalAggregations;