"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVisOptions = MetricVisOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const metricColorMode = [{
  id: _public2.ColorMode.None,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.noneOptionLabel', {
    defaultMessage: 'None'
  })
}, {
  id: _public2.ColorMode.Labels,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.labelsOptionLabel', {
    defaultMessage: 'Labels'
  })
}, {
  id: _public2.ColorMode.Background,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.backgroundOptionLabel', {
    defaultMessage: 'Background'
  })
}];
function MetricVisOptions({
  stateParams,
  setValue,
  setValidity,
  setTouched,
  uiState
}) {
  const setMetricValue = (0, _react.useCallback)((paramName, value) => setValue('metric', {
    ...stateParams.metric,
    [paramName]: value
  }), [setValue, stateParams.metric]);
  const setMetricLabels = (0, _react.useCallback)((paramName, value) => setMetricValue('labels', {
    ...stateParams.metric.labels,
    [paramName]: value
  }), [setMetricValue, stateParams.metric.labels]);
  const setMetricStyle = (0, _react.useCallback)((paramName, value) => setMetricValue('style', {
    ...stateParams.metric.style,
    [paramName]: value
  }), [setMetricValue, stateParams.metric.style]);
  const setColorMode = (0, _react.useCallback)(id => setMetricValue('metricColorMode', id), [setMetricValue]);
  const metricColorModeLabel = _i18n.i18n.translate('visTypeMetric.params.color.useForLabel', {
    defaultMessage: 'Use color for'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.PercentageModeOption, {
    "data-test-subj": "metricPercentageMode",
    percentageMode: stateParams.metric.percentageMode,
    formatPattern: stateParams.metric.percentageFormatPattern,
    setValue: setMetricValue
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeMetric.params.showTitleLabel', {
      defaultMessage: 'Show title'
    }),
    paramName: "show",
    value: stateParams.metric.labels.show,
    setValue: setMetricLabels
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.rangesTitle",
    defaultMessage: "Ranges"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.ColorRanges, {
    "data-test-subj": "metricColorRange",
    colorsRange: stateParams.metric.colorsRange,
    setValue: setMetricValue,
    setTouched: setTouched,
    setValidity: setValidity
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "rowCompressed",
    label: metricColorModeLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    idSelected: stateParams.metric.metricColorMode,
    isDisabled: stateParams.metric.colorsRange.length === 1,
    isFullWidth: true,
    legend: metricColorModeLabel,
    options: metricColorMode,
    onChange: setColorMode
  })), /*#__PURE__*/_react.default.createElement(_public.ColorSchemaOptions, {
    colorSchema: stateParams.metric.colorSchema,
    colorSchemas: _public2.colorSchemas,
    disabled: stateParams.metric.colorsRange.length === 1 || stateParams.metric.metricColorMode === _public2.ColorMode.None,
    invertColors: stateParams.metric.invertColors,
    setValue: setMetricValue,
    showHelpText: false,
    uiState: uiState
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.style.styleTitle",
    defaultMessage: "Style"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.RangeOption, {
    label: _i18n.i18n.translate('visTypeMetric.params.style.fontSizeLabel', {
      defaultMessage: 'Metric font size in points'
    }),
    min: 12,
    max: 120,
    paramName: "fontSize",
    value: stateParams.metric.style.fontSize,
    setValue: setMetricStyle,
    showInput: true,
    showLabels: true,
    showValue: false
  })));
}