"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeatmapVisTypeDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _types = require("../types");
var _to_ast = require("../to_ast");
var _components = require("../editor/components");
var _convert_to_lens = require("../convert_to_lens");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getHeatmapVisTypeDefinition = ({
  showElasticChartsOptions = false,
  palettes
}) => ({
  name: 'heatmap',
  title: _i18n.i18n.translate('visTypeHeatmap.heatmap.heatmapTitle', {
    defaultMessage: 'Heat map'
  }),
  icon: 'heatmap',
  description: _i18n.i18n.translate('visTypeHeatmap.heatmap.heatmapDescription', {
    defaultMessage: 'Display values as colors in a matrix.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  getSupportedTriggers: () => [_public3.VIS_EVENT_TO_TRIGGER.filter],
  visConfig: {
    defaults: {
      type: 'heatmap',
      addTooltip: true,
      addLegend: true,
      enableHover: false,
      legendPosition: _charts.Position.Right,
      colorsNumber: 4,
      colorSchema: _public2.ColorSchemas.GreenToRed,
      setColorRange: false,
      colorsRange: [],
      invertColors: false,
      percentageMode: false,
      valueAxes: [{
        show: false,
        id: 'ValueAxis-1',
        type: _types.AxisType.Value,
        scale: {
          type: _types.ScaleType.Linear,
          defaultYExtents: false
        },
        labels: {
          show: false,
          rotate: 0,
          overwriteColor: false,
          color: 'black'
        }
      }]
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: (0, _components.getHeatmapOptions)({
      showElasticChartsOptions,
      palettes
    }),
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeHeatmap.heatmap.metricTitle', {
        defaultMessage: 'Value'
      }),
      min: 1,
      max: 1,
      aggFilter: ['count', 'avg', 'median', 'sum', 'min', 'max', 'cardinality', 'std_dev', 'top_hits', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'segment',
      title: _i18n.i18n.translate('visTypeHeatmap.heatmap.segmentTitle', {
        defaultMessage: 'X-axis'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'group',
      title: _i18n.i18n.translate('visTypeHeatmap.heatmap.groupTitle', {
        defaultMessage: 'Y-axis'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'split',
      title: _i18n.i18n.translate('visTypeHeatmap.heatmap.splitTitle', {
        defaultMessage: 'Split chart'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => vis ? (0, _convert_to_lens.convertToLens)(vis, timefilter) : null,
  getExpressionVariables: async (vis, timeFilter) => {
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await (0, _convert_to_lens.convertToLens)(vis, timeFilter) : null)
    };
  }
});
exports.getHeatmapVisTypeDefinition = getHeatmapVisTypeDefinition;