"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisTypeHeatmapPlugin = void 0;
var _common = require("../common");
var _vis_type = require("./vis_type");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class VisTypeHeatmapPlugin {
  setup(core, {
    visualizations,
    charts,
    usageCollection
  }) {
    if (!core.uiSettings.get(_common.LEGACY_HEATMAP_CHARTS_LIBRARY)) {
      visualizations.createBaseVisualization((0, _vis_type.heatmapVisType)({
        showElasticChartsOptions: true,
        palettes: charts.palettes
      }));
    }
    return {};
  }
  start(core, {
    dataViews
  }) {
    (0, _services.setDataViewsStart)(dataViews);
  }
}
exports.VisTypeHeatmapPlugin = VisTypeHeatmapPlugin;