"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisTypeGaugePlugin = void 0;
var _common = require("../common");
var _vis_type = require("./vis_type");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class VisTypeGaugePlugin {
  setup(core, {
    visualizations
  }) {
    if (!core.uiSettings.get(_common.LEGACY_GAUGE_CHARTS_LIBRARY)) {
      const visTypeProps = {
        showElasticChartsOptions: true
      };
      visualizations.createBaseVisualization((0, _vis_type.gaugeVisType)(visTypeProps));
      visualizations.createBaseVisualization((0, _vis_type.goalVisType)(visTypeProps));
    }
    return {};
  }
  start(core, {
    dataViews
  }) {
    (0, _services.setDataViewsStart)(dataViews);
  }
}
exports.VisTypeGaugePlugin = VisTypeGaugePlugin;