"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangesPanel = RangesPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function RangesPanel({
  showElasticChartsOptions,
  setGaugeValue,
  setTouched,
  setValidity,
  setValue,
  stateParams,
  uiState
}) {
  const setColorSchemaOptions = (0, _react.useCallback)((paramName, value) => {
    setGaugeValue(paramName, value);
    // set outline if color schema is changed to greys
    // if outline wasn't set explicitly yet
    if (paramName === 'colorSchema' && value === _public2.ColorSchemas.Greys && typeof stateParams.gauge.outline === 'undefined') {
      setGaugeValue('outline', true);
    }
  }, [setGaugeValue, stateParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeGauge.controls.gaugeOptions.rangesTitle",
    defaultMessage: "Ranges"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.ColorRanges, {
    "data-test-subj": "gaugeColorRange",
    colorsRange: stateParams.gauge.colorsRange,
    setValue: setGaugeValue,
    setTouched: setTouched,
    setValidity: setValidity
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    disabled: showElasticChartsOptions || stateParams.gauge.colorsRange.length < 2,
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.autoExtendRangeLabel', {
      defaultMessage: 'Auto extend range'
    }),
    tooltip: showElasticChartsOptions ? _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.extendRangeTooltipNotAvailable', {
      defaultMessage: 'The new charts library supports only extended ranges. To disable it, please, enable the gauge legacy charts library advanced setting.'
    }) : _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.extendRangeTooltip', {
      defaultMessage: 'Extends range to the maximum value in your data.'
    }),
    paramName: "extendRange",
    value: stateParams.gauge.extendRange,
    setValue: setGaugeValue
  }), /*#__PURE__*/_react.default.createElement(_public.PercentageModeOption, {
    "data-test-subj": "gaugePercentageMode",
    percentageMode: stateParams.gauge.percentageMode,
    formatPattern: stateParams.gauge.percentageFormatPattern,
    setValue: setGaugeValue
  }), /*#__PURE__*/_react.default.createElement(_public.ColorSchemaOptions, {
    disabled: stateParams.gauge.colorsRange.length < 2,
    colorSchema: stateParams.gauge.colorSchema,
    colorSchemas: _public2.colorSchemas,
    invertColors: stateParams.gauge.invertColors,
    uiState: uiState,
    setValue: setColorSchemaOptions
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, (0, _extends2.default)({
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showOutline', {
      defaultMessage: 'Show outline'
    }),
    paramName: "outline",
    value: stateParams.gauge.outline,
    setValue: setGaugeValue,
    disabled: showElasticChartsOptions
  }, showElasticChartsOptions ? {
    tooltip: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showOutlineNotAvailable', {
      defaultMessage: 'The outline is not supported with the new charts library. Please, enable the gauge legacy charts library advanced setting.'
    })
  } : {})), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, (0, _extends2.default)({
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showLegendLabel', {
      defaultMessage: 'Show legend'
    }),
    paramName: "addLegend",
    value: stateParams.addLegend,
    setValue: setValue,
    disabled: showElasticChartsOptions
  }, showElasticChartsOptions ? {
    tooltip: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showLegendNotAvailable', {
      defaultMessage: 'The legend is not supported with the new charts library. Please, enable the gauge legacy charts library advanced setting.'
    })
  } : {})), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showScaleLabel', {
      defaultMessage: 'Show scale'
    }),
    paramName: "show",
    value: stateParams.gauge.scale.show,
    setValue: (paramName, value) => setGaugeValue('scale', {
      ...stateParams.gauge.scale,
      [paramName]: value
    })
  }));
}