"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGaugeTypes = exports.getGaugeCollections = exports.getAlignments = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/charts-plugin/public");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getGaugeTypes = () => [{
  text: _i18n.i18n.translate('visTypeGauge.gauge.gaugeTypes.arcText', {
    defaultMessage: 'Arc'
  }),
  value: _types.GaugeType.Arc
}, {
  text: _i18n.i18n.translate('visTypeGauge.gauge.gaugeTypes.circleText', {
    defaultMessage: 'Circle'
  }),
  value: _types.GaugeType.Circle
}];
exports.getGaugeTypes = getGaugeTypes;
const getAlignments = () => [{
  text: _i18n.i18n.translate('visTypeGauge.gauge.alignmentAutomaticTitle', {
    defaultMessage: 'Automatic'
  }),
  value: _types.Alignment.Automatic
}, {
  text: _i18n.i18n.translate('visTypeGauge.gauge.alignmentHorizontalTitle', {
    defaultMessage: 'Horizontal'
  }),
  value: _types.Alignment.Horizontal
}, {
  text: _i18n.i18n.translate('visTypeGauge.gauge.alignmentVerticalTitle', {
    defaultMessage: 'Vertical'
  }),
  value: _types.Alignment.Vertical
}];
exports.getAlignments = getAlignments;
const getGaugeCollections = () => ({
  gaugeTypes: getGaugeTypes(),
  alignments: getAlignments(),
  colorSchemas: _public.colorSchemas
});
exports.getGaugeCollections = getGaugeCollections;