"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isColumnWithMeta = exports.excludeMetaFromColumn = exports.convertToLens = void 0;
var _uuid = require("uuid");
var _public = require("@kbn/visualizations-plugin/public");
var _services = require("../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const isColumnWithMeta = column => {
  if (column.meta) {
    return true;
  }
  return false;
};
exports.isColumnWithMeta = isColumnWithMeta;
const excludeMetaFromColumn = column => {
  if (isColumnWithMeta(column)) {
    const {
      meta,
      ...rest
    } = column;
    return rest;
  }
  return column;
};
exports.excludeMetaFromColumn = excludeMetaFromColumn;
const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const [{
    getColumnsFromVis,
    createStaticValueColumn,
    getPalette,
    getPercentageModeConfig
  }, {
    getConfiguration
  }] = await Promise.all([_public.convertToLensModule, Promise.resolve().then(() => _interopRequireWildcard(require('./configurations/gauge')))]);
  const percentageModeConfig = getPercentageModeConfig(vis.params.gauge, false);
  const layers = getColumnsFromVis(vis, timefilter, dataView, {
    unsupported: ['group']
  }, {
    dropEmptyRowsInDateHistogram: true,
    ...percentageModeConfig
  });
  if (layers === null) {
    return null;
  }
  const [layerConfig] = layers;

  // for now, multiple metrics are not supported
  if (layerConfig.metrics.length > 1 || layerConfig.buckets.all.length) {
    return null;
  }
  if (layerConfig.metrics[0]) {
    const metric = layerConfig.columns.find(({
      columnId
    }) => columnId === layerConfig.metrics[0]);
    if ((metric === null || metric === void 0 ? void 0 : metric.dataType) !== 'number') {
      return null;
    }
  }
  const layerId = (0, _uuid.v4)();
  const indexPatternId = dataView.id;
  const metricAccessor = layerConfig.metrics[0];
  const {
    min,
    max,
    isPercentageMode
  } = percentageModeConfig;
  const minColumn = createStaticValueColumn(isPercentageMode ? 0 : min);
  const maxColumn = createStaticValueColumn(isPercentageMode ? 1 : max);
  const columns = [...layerConfig.columns, minColumn, maxColumn];
  return {
    type: 'lnsGauge',
    layers: [{
      indexPatternId,
      layerId,
      columns: columns.map(excludeMetaFromColumn),
      columnOrder: []
    }],
    configuration: getConfiguration(layerId, vis.params, getPalette(vis.params.gauge, percentageModeConfig, true), {
      metricAccessor,
      minAccessor: minColumn.columnId,
      maxAccessor: maxColumn.columnId
    }),
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;