"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupAndSortBy = groupAndSortBy;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Groups and sorts alphabetically objects and returns an array of options that are compatible with EuiComboBox options.
 *
 * @param objects An array of objects that will be grouped.
 * @param groupBy A field name which objects are grouped by.
 * @param labelName A name of a property which value will be displayed.
 *
 * @returns An array of grouped and sorted alphabetically `objects` that are compatible with EuiComboBox options.
 */
function groupAndSortBy(objects, groupBy, labelName, keyName) {
  const groupedOptions = objects.reduce((array, obj) => {
    const group = array.find(element => element.label === obj[groupBy]);
    const option = {
      label: obj[labelName],
      target: obj,
      ...(keyName ? {
        key: obj[keyName]
      } : {})
    };
    if (group && group.options) {
      group.options.push(option);
    } else {
      array.push({
        label: obj[groupBy],
        options: [option]
      });
    }
    return array;
  }, []);
  groupedOptions.sort(sortByLabel);
  groupedOptions.forEach(group => {
    if (Array.isArray(group.options)) {
      group.options.sort(sortByLabel);
    }
  });
  if (groupedOptions.length === 1 && !groupedOptions[0].label) {
    return groupedOptions[0].options || [];
  }
  return groupedOptions;
}
function sortByLabel(a, b) {
  return (a.label || '').toLowerCase().localeCompare((b.label || '').toLowerCase());
}