"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeOption = RangeOption;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function RangeOption({
  label,
  max,
  min,
  showInput,
  showLabels,
  showValue = true,
  step,
  paramName,
  value,
  setValue
}) {
  const [stateValue, setStateValue] = (0, _react.useState)(value);
  const [isValidState, setIsValidState] = (0, _react.useState)(true);
  const error = _i18n.i18n.translate('visDefaultEditor.options.rangeErrorMessage', {
    defaultMessage: 'Values must be on or between {min} and {max}',
    values: {
      min,
      max
    }
  });
  const onChangeHandler = (event, isValid) => {
    const {
      valueAsNumber
    } = event.target; // since we don't show ticks on EuiRange, the target will definitely be HTMLInputElement type, so we can cast it directly.

    setStateValue(valueAsNumber);
    setIsValidState(isValid);
    if (isValid) {
      setValue(paramName, valueAsNumber);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: !isValidState,
    error: error,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    max: max,
    min: min,
    showInput: showInput,
    showLabels: showLabels,
    showValue: showValue,
    step: step,
    value: stateValue,
    onChange: onChangeHandler
  }));
}