"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorRanges = ColorRanges;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _ranges = require("../controls/ranges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ColorRanges({
  'data-test-subj': dataTestSubj,
  colorsRange,
  setValue,
  setValidity,
  setTouched
}) {
  const addRangeValues = (0, _react.useCallback)(() => {
    const previousRange = (0, _lodash.last)(colorsRange) || {};
    const from = previousRange.to ? previousRange.to : 0;
    const to = previousRange.to ? from + (previousRange.to - (previousRange.from || 0)) : 100;
    return {
      from,
      to
    };
  }, [colorsRange]);
  const validateRange = (0, _react.useCallback)(({
    from,
    to
  }, index) => {
    if (!colorsRange[index]) {
      return [false, false];
    }
    const leftBound = index === 0 ? -Infinity : colorsRange[index - 1].to || 0;
    const isFromValid = from >= leftBound;
    const isToValid = to >= from;
    return [isFromValid, isToValid];
  }, [colorsRange]);
  const setColorRanges = (0, _react.useCallback)(value => setValue('colorsRange', value), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_ranges.RangesParamEditor, {
    "data-test-subj": dataTestSubj,
    error: _i18n.i18n.translate('visDefaultEditor.options.colorRanges.errorText', {
      defaultMessage: 'Each range should be greater than previous.'
    }),
    hidePlaceholders: true,
    value: colorsRange,
    setValue: setColorRanges,
    setValidity: setValidity,
    setTouched: setTouched,
    addRangeValues: addRangeValues,
    validateRange: validateRange
  });
}