"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicOptions = BasicOptions;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _switch = require("./switch");
var _select = require("./select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function BasicOptions({
  stateParams,
  setValue,
  legendPositions
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_select.SelectOption, {
    label: _i18n.i18n.translate('visDefaultEditor.options.vislibBasicOptions.legendPositionLabel', {
      defaultMessage: 'Legend position'
    }),
    options: legendPositions,
    paramName: "legendPosition",
    value: stateParams.legendPosition,
    setValue: setValue
  }), /*#__PURE__*/_react.default.createElement(_switch.SwitchOption, {
    label: _i18n.i18n.translate('visDefaultEditor.options.vislibBasicOptions.showTooltipLabel', {
      defaultMessage: 'Show tooltip'
    }),
    paramName: "addTooltip",
    value: stateParams.addTooltip,
    setValue: setValue
  }));
}