"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadiusRatioOptionControl = RadiusRatioOptionControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_VALUE = 50;
const PARAM_NAME = 'radiusRatio';
function RadiusRatioOptionControl({
  editorStateParams,
  setStateParamValue
}) {
  const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.dotSizeRatioLabel",
    defaultMessage: "Dot size ratio"
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visDefaultEditor.controls.dotSizeRatioHelpText', {
      defaultMessage: 'Change the ratio of the radius of the smallest point to the largest point.'
    }),
    position: "right"
  }));
  (0, _useMount.default)(() => {
    if (!editorStateParams.radiusRatio) {
      setStateParamValue(PARAM_NAME, DEFAULT_VALUE);
    }
  });
  const onChange = (0, _react.useCallback)(e => setStateParamValue(PARAM_NAME, parseFloat(e.currentTarget.value)), [setStateParamValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: label,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    min: 1,
    max: 100,
    value: editorStateParams.radiusRatio || DEFAULT_VALUE,
    onChange: onChange,
    showRange: true,
    showValue: true,
    valueAppend: "%"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}