"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentilesEditor = PercentilesEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _number_list = require("./components/number_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PercentilesEditor({
  agg,
  showValidation,
  value = [],
  setTouched,
  setValidity,
  setValue
}) {
  const label = _i18n.i18n.translate('visDefaultEditor.controls.percentiles.percentsLabel', {
    defaultMessage: 'Percents'
  });
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const setModelValidity = (0, _react.useCallback)(isListValid => {
    setIsValid(isListValid);
    setValidity(isListValid);
  }, [setValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    labelType: "legend",
    fullWidth: true,
    id: `visEditorPercentileLabel${agg.id}`,
    isInvalid: showValidation ? !isValid : false,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_number_list.NumberList, {
    labelledbyId: `visEditorPercentileLabel${agg.id}-legend`,
    numberArray: value,
    range: "[0,100]",
    disallowDuplicates: true,
    unitName: _i18n.i18n.translate('visDefaultEditor.controls.percentileRanks.percentUnitNameText', {
      defaultMessage: 'percent'
    }),
    showValidation: showValidation,
    onChange: setValue,
    setTouched: setTouched,
    setValidity: setModelValidity
  }));
}