"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = PalettePicker;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_PALETTE = 'default';
function PalettePicker({
  activePalette,
  palettes,
  paramName,
  setPalette
}) {
  const palettesList = palettes.getAll().filter(({
    internal
  }) => !internal).map(({
    id,
    title,
    getCategoricalColors
  }) => {
    return {
      value: id,
      title,
      type: 'fixed',
      palette: getCategoricalColors(10, id === (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) ? activePalette === null || activePalette === void 0 ? void 0 : activePalette.params : undefined)
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('visDefaultEditor.palettePicker.label', {
      defaultMessage: 'Color palette'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    fullWidth: true,
    "data-test-subj": "visEditorPalettePicker",
    compressed: true,
    palettes: palettesList,
    onChange: newPalette => {
      var _palette$value;
      const palette = palettesList.find(item => item.value === newPalette);
      setPalette(paramName, {
        type: 'palette',
        name: (_palette$value = palette === null || palette === void 0 ? void 0 : palette.value) !== null && _palette$value !== void 0 ? _palette$value : DEFAULT_PALETTE
      });
    },
    valueOfSelected: (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) || DEFAULT_PALETTE,
    selectionDisplay: 'palette'
  }));
}