"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberIntervalParamEditor = NumberIntervalParamEditor;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.numberInterval.minimumIntervalLabel",
  defaultMessage: "Minimum interval"
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "right",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.numberInterval.minimumIntervalTooltip",
    defaultMessage: "Interval will be automatically scaled in the event that the provided value creates more buckets than specified by Advanced Setting's {histogramMaxBars}",
    values: {
      histogramMaxBars: _public.UI_SETTINGS.HISTOGRAM_MAX_BARS
    }
  }),
  type: "questionInCircle"
}));
const autoInterval = 'auto';
const isAutoInterval = value => value === autoInterval;
const selectIntervalPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.numberInterval.selectIntervalPlaceholder', {
  defaultMessage: 'Enter an interval'
});
const autoIntervalIsUsedPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.numberInterval.autoInteralIsUsed', {
  defaultMessage: 'Auto interval is used'
});
const useAutoIntervalLabel = _i18n.i18n.translate('visDefaultEditor.controls.useAutoInterval', {
  defaultMessage: 'Use auto interval'
});
function NumberIntervalParamEditor({
  agg,
  editorConfig,
  showValidation,
  value,
  setTouched,
  setValidity,
  setValue
}) {
  const field = agg.getField();
  const fieldSupportsAuto = !field || field.type === 'number';
  const isAutoChecked = fieldSupportsAuto && isAutoInterval(value);
  const base = (0, _lodash.get)(editorConfig, 'interval.base');
  const min = base || 0;
  const isValid = value !== '' && value !== undefined && (isAutoChecked || Number(value) >= min);
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  const onChange = (0, _react.useCallback)(({
    target
  }) => setValue(isNaN(target.valueAsNumber) ? '' : target.valueAsNumber), [setValue]);
  const onAutoSwitchChange = (0, _react.useCallback)(e => {
    const isAutoSwitchChecked = e.target.checked;
    setValue(isAutoSwitchChecked ? autoInterval : '');
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    helpText: (0, _lodash.get)(editorConfig, 'interval.help')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: useAutoIntervalLabel,
    onChange: onAutoSwitchChange,
    checked: isAutoChecked,
    compressed: true,
    disabled: !fieldSupportsAuto,
    "data-test-subj": `visEditorIntervalSwitch${agg.id}`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: !isAutoChecked ? value : '',
    min: min,
    step: base || 'any',
    "data-test-subj": `visEditorInterval${agg.id}`,
    isInvalid: showValidation && !isValid,
    onChange: onChange,
    onBlur: setTouched,
    disabled: isAutoChecked,
    fullWidth: true,
    compressed: true,
    placeholder: isAutoChecked ? autoIntervalIsUsedPlaceholder : selectIntervalPlaceholder
  }))));
}