"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpRangeTypeParamEditor = IpRangeTypeParamEditor;
exports.IpRangeTypes = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var IpRangeTypes;
exports.IpRangeTypes = IpRangeTypes;
(function (IpRangeTypes) {
  IpRangeTypes["MASK"] = "mask";
  IpRangeTypes["FROM_TO"] = "fromTo";
})(IpRangeTypes || (exports.IpRangeTypes = IpRangeTypes = {}));
function IpRangeTypeParamEditor({
  agg,
  value,
  setValue
}) {
  const options = [{
    id: `visEditorIpRangeFromToLabel${agg.id}`,
    label: _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.fromToButtonLabel', {
      defaultMessage: 'From/to'
    })
  }, {
    id: `visEditorIpRangeCidrLabel${agg.id}`,
    label: _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.cidrMasksButtonLabel', {
      defaultMessage: 'CIDR masks'
    })
  }];
  const onClick = optionId => {
    setValue(optionId === options[0].id ? IpRangeTypes.FROM_TO : IpRangeTypes.MASK);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    onChange: onClick,
    idSelected: value === IpRangeTypes.FROM_TO ? options[0].id : options[1].id,
    options: options,
    legend: _i18n.i18n.translate('visDefaultEditor.controls.ipRangesAriaLabel', {
      defaultMessage: 'IP ranges'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}