"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NumberList = NumberList;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _number_row = require("./number_row");
var _utils = require("./utils");
var _utils2 = require("../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function NumberList({
  labelledbyId,
  numberArray,
  range,
  showValidation,
  unitName,
  validateAscendingOrder = false,
  disallowDuplicates = false,
  onChange,
  setTouched,
  setValidity
}) {
  const numberRange = (0, _react.useMemo)(() => (0, _utils.getRange)(range), [range]);
  const [models, setModels] = (0, _react.useState)((0, _utils.getInitModelList)(numberArray));

  // set up validity for each model
  (0, _react.useEffect)(() => {
    setModels(state => (0, _utils.getValidatedModels)(numberArray, state, numberRange, validateAscendingOrder, disallowDuplicates));
  }, [numberArray, numberRange, validateAscendingOrder, disallowDuplicates]);

  // responsible for setting up an initial value ([0]) when there is no default value
  (0, _react.useEffect)(() => {
    if (!numberArray.length) {
      onChange([models[0].value]);
    }
  }, [models, numberArray.length, onChange]);
  const isValid = !(0, _utils.hasInvalidValues)(models);
  (0, _utils2.useValidation)(setValidity, isValid);
  const onUpdate = (0, _react.useCallback)(modelList => {
    setModels(modelList);
    onChange(modelList.map(({
      value
    }) => value === _utils.EMPTY_STRING ? undefined : value));
  }, [onChange]);
  const onChangeValue = (0, _react.useCallback)(({
    id,
    value
  }) => {
    const parsedValue = (0, _utils.parse)(value);
    onUpdate(models.map(model => {
      if (model.id === id) {
        return {
          id,
          value: parsedValue,
          isInvalid: false
        };
      }
      return model;
    }));
  }, [models, onUpdate]);

  // Add an item to the end of the list
  const onAdd = (0, _react.useCallback)(() => {
    const newArray = [...models, (0, _utils.getNextModel)(models, numberRange)];
    onUpdate(newArray);
  }, [models, numberRange, onUpdate]);
  const onDelete = (0, _react.useCallback)(id => {
    const newArray = models.filter(model => model.id !== id);
    onUpdate(newArray);
  }, [models, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, models.map((model, arrayIndex) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: model.id
  }, /*#__PURE__*/_react.default.createElement(_number_row.NumberRow, {
    isInvalid: showValidation ? model.isInvalid : false,
    disableDelete: models.length === 1,
    model: model,
    labelledbyId: labelledbyId,
    range: numberRange,
    onDelete: onDelete,
    onChange: onChangeValue,
    onBlur: setTouched,
    autoFocus: models.length !== 1 && arrayIndex === models.length - 1
  }), showValidation && model.isInvalid && model.error && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, model.error), models.length - 1 !== arrayIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.numberList.addUnitButtonLabel",
    defaultMessage: "Add {unitName}",
    values: {
      unitName
    }
  }))));
}