"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaskList = MaskList;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _input_list = require("./input_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_STRING = '';
const defaultConfig = {
  defaultValue: {
    mask: {
      model: '0.0.0.0/1',
      value: '0.0.0.0/1',
      isInvalid: false
    }
  },
  validateClass: _public.search.aggs.CidrMask,
  getModelValue: (item = {}) => ({
    mask: {
      model: item.mask || EMPTY_STRING,
      value: item.mask || EMPTY_STRING,
      isInvalid: false
    }
  }),
  getRemoveBtnAriaLabel: item => item.mask.value ? _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.removeCidrMaskButtonAriaLabel', {
    defaultMessage: 'Remove the CIDR mask value of {mask}',
    values: {
      mask: item.mask.value
    }
  }) : _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.removeEmptyCidrMaskButtonAriaLabel', {
    defaultMessage: 'Remove the CIDR mask default value'
  }),
  onChangeFn: ({
    mask
  }) => {
    if (mask.model) {
      return {
        mask: mask.model
      };
    }
    return {};
  },
  hasInvalidValuesFn: ({
    mask
  }) => mask.isInvalid,
  modelNames: 'mask'
};
function MaskList({
  showValidation,
  onBlur,
  ...rest
}) {
  const renderInputRow = (0, _react.useCallback)(({
    mask
  }, index, onChangeValue) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.cidrMaskAriaLabel', {
      defaultMessage: 'CIDR mask: {mask}',
      values: {
        mask: mask.value || '*'
      }
    }),
    compressed: true,
    fullWidth: true,
    isInvalid: showValidation ? mask.isInvalid : false,
    placeholder: "*",
    onChange: ev => {
      onChangeValue(index, ev.target.value, 'mask');
    },
    value: mask.value,
    onBlur: onBlur
  })), [onBlur, showValidation]);
  const maskListConfig = {
    ...defaultConfig,
    renderInputRow
  };
  return /*#__PURE__*/_react.default.createElement(_input_list.InputList, (0, _extends2.default)({
    config: maskListConfig
  }, rest));
}