"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PERCENTILE_DEFAULT = exports.DEFAULT_RANKS = void 0;
exports.coreWebVitalsQuery = coreWebVitalsQuery;
exports.transformCoreWebVitalsResponse = transformCoreWebVitalsResponse;
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _merge_projection = require("../../../common/utils/merge_projection");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_RANKS = [100, 0, 0];
exports.DEFAULT_RANKS = DEFAULT_RANKS;
const getRanksPercentages = ranks => {
  var _ranks$map;
  if (!Array.isArray(ranks)) return null;
  const ranksVal = (_ranks$map = ranks === null || ranks === void 0 ? void 0 : ranks.map(({
    value
  }) => {
    var _value$toFixed;
    return (_value$toFixed = value === null || value === void 0 ? void 0 : value.toFixed(0)) !== null && _value$toFixed !== void 0 ? _value$toFixed : 0;
  })) !== null && _ranks$map !== void 0 ? _ranks$map : [];
  return [Number(ranksVal === null || ranksVal === void 0 ? void 0 : ranksVal[0]), Number(ranksVal === null || ranksVal === void 0 ? void 0 : ranksVal[1]) - Number(ranksVal === null || ranksVal === void 0 ? void 0 : ranksVal[0]), 100 - Number(ranksVal === null || ranksVal === void 0 ? void 0 : ranksVal[1])];
};
function transformCoreWebVitalsResponse(response, percentile = PERCENTILE_DEFAULT) {
  var _response$aggregation, _coreVitalPages$doc_c, _cls$values$pkey, _tbt$values$pkey, _getRanksPercentages, _getRanksPercentages2, _getRanksPercentages3;
  if (!response) return response;
  const {
    lcp,
    cls,
    fid,
    tbt,
    fcp,
    lcpRanks,
    fidRanks,
    clsRanks,
    coreVitalPages
  } = (_response$aggregation = response.aggregations) !== null && _response$aggregation !== void 0 ? _response$aggregation : {};
  const pkey = percentile.toFixed(1);
  return {
    coreVitalPages: (_coreVitalPages$doc_c = coreVitalPages === null || coreVitalPages === void 0 ? void 0 : coreVitalPages.doc_count) !== null && _coreVitalPages$doc_c !== void 0 ? _coreVitalPages$doc_c : 0,
    /* Because cls is required in the type UXMetrics, and defined as number | null,
     * we need to default to null in the case where cls is undefined in order to satisfy the UXMetrics type */
    cls: (_cls$values$pkey = cls === null || cls === void 0 ? void 0 : cls.values[pkey]) !== null && _cls$values$pkey !== void 0 ? _cls$values$pkey : null,
    fid: fid === null || fid === void 0 ? void 0 : fid.values[pkey],
    lcp: lcp === null || lcp === void 0 ? void 0 : lcp.values[pkey],
    tbt: (_tbt$values$pkey = tbt === null || tbt === void 0 ? void 0 : tbt.values[pkey]) !== null && _tbt$values$pkey !== void 0 ? _tbt$values$pkey : 0,
    fcp: fcp === null || fcp === void 0 ? void 0 : fcp.values[pkey],
    lcpRanks: lcp !== null && lcp !== void 0 && lcp.values[pkey] ? (_getRanksPercentages = getRanksPercentages(lcpRanks === null || lcpRanks === void 0 ? void 0 : lcpRanks.values)) !== null && _getRanksPercentages !== void 0 ? _getRanksPercentages : DEFAULT_RANKS : DEFAULT_RANKS,
    fidRanks: fid !== null && fid !== void 0 && fid.values[pkey] ? (_getRanksPercentages2 = getRanksPercentages(fidRanks === null || fidRanks === void 0 ? void 0 : fidRanks.values)) !== null && _getRanksPercentages2 !== void 0 ? _getRanksPercentages2 : DEFAULT_RANKS : DEFAULT_RANKS,
    clsRanks: cls !== null && cls !== void 0 && cls.values[pkey] ? (_getRanksPercentages3 = getRanksPercentages(clsRanks === null || clsRanks === void 0 ? void 0 : clsRanks.values)) !== null && _getRanksPercentages3 !== void 0 ? _getRanksPercentages3 : DEFAULT_RANKS : DEFAULT_RANKS
  };
}
const PERCENTILE_DEFAULT = 50;
exports.PERCENTILE_DEFAULT = PERCENTILE_DEFAULT;
function coreWebVitalsQuery(start, end, urlQuery, uiFilters, percentile = PERCENTILE_DEFAULT) {
  const setup = {
    uiFilters: uiFilters !== null && uiFilters !== void 0 ? uiFilters : {}
  };
  const projection = (0, _projections.getRumPageLoadTransactionsProjection)({
    setup,
    urlQuery,
    start,
    end
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    body: {
      size: 0,
      query: {
        bool: {
          filter: [...projection.body.query.bool.filter]
        }
      },
      aggs: {
        coreVitalPages: {
          filter: {
            exists: {
              field: 'transaction.experience'
            }
          }
        },
        lcp: {
          percentiles: {
            field: _elasticsearch_fieldnames.LCP_FIELD,
            percents: [percentile]
          }
        },
        fid: {
          percentiles: {
            field: _elasticsearch_fieldnames.FID_FIELD,
            percents: [percentile]
          }
        },
        cls: {
          percentiles: {
            field: _elasticsearch_fieldnames.CLS_FIELD,
            percents: [percentile]
          }
        },
        tbt: {
          percentiles: {
            field: _elasticsearch_fieldnames.TBT_FIELD,
            percents: [percentile]
          }
        },
        fcp: {
          percentiles: {
            field: _elasticsearch_fieldnames.FCP_FIELD,
            percents: [percentile]
          }
        },
        lcpRanks: {
          percentile_ranks: {
            field: _elasticsearch_fieldnames.LCP_FIELD,
            values: [2500, 4000],
            keyed: false
          }
        },
        fidRanks: {
          percentile_ranks: {
            field: _elasticsearch_fieldnames.FID_FIELD,
            values: [100, 300],
            keyed: false
          }
        },
        clsRanks: {
          percentile_ranks: {
            field: _elasticsearch_fieldnames.CLS_FIELD,
            values: [0.1, 0.25],
            keyed: false
          }
        }
      }
    }
  });
  return params;
}