"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStaticDataView = useStaticDataView;
var _public = require("@kbn/observability-plugin/public");
var _use_kibana_services = require("./use_kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStaticDataView() {
  const {
    exploratoryView
  } = (0, _use_kibana_services.useKibanaServices)();
  const {
    data,
    loading
  } = (0, _public.useFetcher)(async () => {
    return exploratoryView.getAppDataView('ux');
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    dataView: data !== null && data !== void 0 ? data : undefined,
    loading
  };
}