"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLongTaskMetricsQuery = useLongTaskMetricsQuery;
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _use_data_view = require("../components/app/rum_dashboard/local_uifilters/use_data_view");
var _long_task_metrics_query = require("../services/data/long_task_metrics_query");
var _call_date_math = require("../services/data/call_date_math");
var _use_url_params = require("../context/url_params_context/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLongTaskMetricsQuery() {
  const {
    rangeId,
    urlParams: {
      start,
      end,
      searchTerm,
      percentile
    },
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: esQueryResponse,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _long_task_metrics_query.longTaskMetricsQuery)((0, _call_date_math.callDateMath)(start), (0, _call_date_math.callDateMath)(end), percentile, searchTerm, uxUiFilters)
  }, [start, end, percentile, searchTerm, uxUiFilters, rangeId, dataViewTitle], {
    name: 'UxLongTaskMetrics'
  });
  const data = (0, _react.useMemo)(() => {
    var _esQueryResponse$aggr, _longTaskCount$values, _longTaskSum$values$p, _longTaskMax$values$p;
    if (!esQueryResponse) return {};
    const pkey = Number(percentile).toFixed(1);
    const {
      longTaskSum,
      longTaskCount,
      longTaskMax
    } = (_esQueryResponse$aggr = esQueryResponse.aggregations) !== null && _esQueryResponse$aggr !== void 0 ? _esQueryResponse$aggr : {};
    return {
      noOfLongTasks: (_longTaskCount$values = longTaskCount === null || longTaskCount === void 0 ? void 0 : longTaskCount.values[pkey]) !== null && _longTaskCount$values !== void 0 ? _longTaskCount$values : 0,
      sumOfLongTasks: (_longTaskSum$values$p = longTaskSum === null || longTaskSum === void 0 ? void 0 : longTaskSum.values[pkey]) !== null && _longTaskSum$values$p !== void 0 ? _longTaskSum$values$p : 0,
      longestLongTask: (_longTaskMax$values$p = longTaskMax === null || longTaskMax === void 0 ? void 0 : longTaskMax.values[pkey]) !== null && _longTaskMax$values$p !== void 0 ? _longTaskMax$values$p : 0
    };
  }, [esQueryResponse, percentile]);
  return {
    data,
    loading
  };
}