"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useJsErrorsQuery = useJsErrorsQuery;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _use_data_view = require("../components/app/rum_dashboard/local_uifilters/use_data_view");
var _js_errors_query = require("../services/data/js_errors_query");
var _use_url_params = require("../context/url_params_context/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function callDateMath(value) {
  const DEFAULT_RETURN_VALUE = 0;
  if (typeof value === 'string') {
    var _datemath$parse$value, _datemath$parse;
    return (_datemath$parse$value = (_datemath$parse = _datemath.default.parse(value)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf()) !== null && _datemath$parse$value !== void 0 ? _datemath$parse$value : DEFAULT_RETURN_VALUE;
  }
  return DEFAULT_RETURN_VALUE;
}
function useJsErrorsQuery(pagination) {
  const {
    rangeId,
    urlParams: {
      start,
      end,
      searchTerm
    },
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: esQueryResponse,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _js_errors_query.jsErrorsQuery)(callDateMath(start), callDateMath(end), pagination.pageSize, pagination.pageIndex, searchTerm, uxUiFilters)
  }, [start, end, searchTerm, uxUiFilters, dataViewTitle, pagination.pageSize, pagination.pageIndex, rangeId], {
    name: 'UxJsErrors'
  });
  const data = (0, _react.useMemo)(() => {
    var _esQueryResponse$aggr, _totalErrorPages$valu, _esQueryResponse$hits, _totalErrorGroups$val;
    if (!esQueryResponse) return {};
    const {
      totalErrorGroups,
      totalErrorPages,
      errors
    } = (_esQueryResponse$aggr = esQueryResponse === null || esQueryResponse === void 0 ? void 0 : esQueryResponse.aggregations) !== null && _esQueryResponse$aggr !== void 0 ? _esQueryResponse$aggr : {};
    return {
      totalErrorPages: (_totalErrorPages$valu = totalErrorPages === null || totalErrorPages === void 0 ? void 0 : totalErrorPages.value) !== null && _totalErrorPages$valu !== void 0 ? _totalErrorPages$valu : 0,
      totalErrors: (_esQueryResponse$hits = esQueryResponse.hits.total.value) !== null && _esQueryResponse$hits !== void 0 ? _esQueryResponse$hits : 0,
      totalErrorGroups: (_totalErrorGroups$val = totalErrorGroups === null || totalErrorGroups === void 0 ? void 0 : totalErrorGroups.value) !== null && _totalErrorGroups$val !== void 0 ? _totalErrorGroups$val : 0,
      items: errors === null || errors === void 0 ? void 0 : errors.buckets.map(({
        sample,
        key,
        impactedPages
      }) => {
        var _error$exception;
        return {
          count: impactedPages.pageCount.value,
          errorGroupId: key,
          errorMessage: (_error$exception = sample.hits.hits[0]._source.error.exception) === null || _error$exception === void 0 ? void 0 : _error$exception[0].message
        };
      })
    };
  }, [esQueryResponse]);
  return {
    data,
    loading
  };
}