"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnvironmentsFetcher = useEnvironmentsFetcher;
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _environment_filter_values = require("../../common/environment_filter_values");
var _use_data_view = require("../components/app/rum_dashboard/local_uifilters/use_data_view");
var _environments_query = require("../services/data/environments_query");
var _call_date_math = require("../services/data/call_date_math");
var _use_kibana_services = require("./use_kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEnvironmentOptions(environments) {
  const environmentOptions = environments.filter(env => env !== _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value).map(environment => ({
    value: environment,
    text: environment
  }));
  return [_environment_filter_values.ENVIRONMENT_ALL, ...environmentOptions];
}
function useEnvironmentsFetcher({
  serviceName,
  start,
  end
}) {
  var _kibana$uiSettings$de, _kibana$uiSettings, _kibana$uiSettings$de2, _kibana$uiSettings$de3;
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const size = // @ts-ignore defaults field should exist and contain this value
  (_kibana$uiSettings$de = (_kibana$uiSettings = kibana.uiSettings) === null || _kibana$uiSettings === void 0 ? void 0 : (_kibana$uiSettings$de2 = _kibana$uiSettings.defaults) === null || _kibana$uiSettings$de2 === void 0 ? void 0 : (_kibana$uiSettings$de3 = _kibana$uiSettings$de2['observability:maxSuggestions']) === null || _kibana$uiSettings$de3 === void 0 ? void 0 : _kibana$uiSettings$de3.value) !== null && _kibana$uiSettings$de !== void 0 ? _kibana$uiSettings$de : 100;
  const {
    data: esQueryResponse,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _environments_query.getEnvironments)({
      serviceName,
      start: (0, _call_date_math.callDateMath)(start),
      end: (0, _call_date_math.callDateMath)(end),
      size
    })
  }, [dataViewTitle, serviceName, start, end, size], {
    name: 'UxEnvironments'
  });
  const environments = (0, _react.useMemo)(() => {
    var _transformEnvironment;
    return (_transformEnvironment = (0, _environments_query.transformEnvironmentsResponse)(esQueryResponse)) !== null && _transformEnvironment !== void 0 ? _transformEnvironment : [];
  }, [esQueryResponse]);
  const environmentOptions = (0, _react.useMemo)(() => getEnvironmentOptions(environments), [environments]);
  return {
    environments,
    loading,
    environmentOptions
  };
}