"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDynamicDataViewTitle = useDynamicDataViewTitle;
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDynamicDataViewTitle() {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/data_view/title', {
      isCachable: true
    });
  }, []);
  return {
    dataViewTitle: data === null || data === void 0 ? void 0 : data.apmDataViewTitle,
    status
  };
}