"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useClientMetricsQuery = useClientMetricsQuery;
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _use_data_view = require("../components/app/rum_dashboard/local_uifilters/use_data_view");
var _use_url_params = require("../context/url_params_context/use_url_params");
var _call_date_math = require("../services/data/call_date_math");
var _client_metrics_query = require("../services/data/client_metrics_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useClientMetricsQuery() {
  const {
    rangeId,
    urlParams: {
      start,
      end,
      percentile = 50,
      searchTerm
    },
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: esQueryResponse,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _client_metrics_query.clientMetricsQuery)((0, _call_date_math.callDateMath)(start), (0, _call_date_math.callDateMath)(end), percentile, searchTerm, uxUiFilters)
  }, [start, end, percentile, searchTerm, uxUiFilters, dataViewTitle, rangeId], {
    name: 'UxClientMetrics'
  });
  const data = (0, _react.useMemo)(() => {
    var _totalPageLoadDuratio, _backEnd$values$pkey, _esQueryResponse$hits;
    if (!(esQueryResponse !== null && esQueryResponse !== void 0 && esQueryResponse.aggregations)) return {};
    const {
      hasFetchStartField: {
        backEnd,
        totalPageLoadDuration
      }
    } = esQueryResponse.aggregations;
    const pkey = percentile.toFixed(1);
    const totalPageLoadDurationValue = (_totalPageLoadDuratio = totalPageLoadDuration.values[pkey]) !== null && _totalPageLoadDuratio !== void 0 ? _totalPageLoadDuratio : 0;
    const totalPageLoadDurationValueMs = totalPageLoadDurationValue / 1000; // Microseconds to milliseconds
    const backendValue = (_backEnd$values$pkey = backEnd.values[pkey]) !== null && _backEnd$values$pkey !== void 0 ? _backEnd$values$pkey : 0;
    return {
      pageViews: {
        value: (_esQueryResponse$hits = esQueryResponse.hits.total.value) !== null && _esQueryResponse$hits !== void 0 ? _esQueryResponse$hits : 0
      },
      totalPageLoadDuration: {
        value: totalPageLoadDurationValueMs
      },
      backEnd: {
        value: backendValue
      },
      frontEnd: {
        value: totalPageLoadDurationValueMs - backendValue
      }
    };
  }, [esQueryResponse, percentile]);
  return {
    data,
    loading
  };
}