"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMap = void 0;
exports.EmbeddedMapComponent = EmbeddedMapComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/maps-plugin/common");
var _public = require("@kbn/embeddable-plugin/public");
var _use_layer_list = require("./use_layer_list");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _map_tooltip = require("./map_tooltip");
var _use_map_filters = require("./use_map_filters");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddedPanel = _styledComponents.default.div`
  z-index: auto;
  flex: 1;
  display: flex;
  flex-direction: column;
  height: 100%;
  position: relative;
  .embPanel__content {
    display: flex;
    flex: 1 1 100%;
    z-index: 1;
    min-height: 0; // Absolute must for Firefox to scroll contents
  }
  &&& .mapboxgl-canvas {
    animation: none !important;
  }
`;
function EmbeddedMapComponent() {
  const {
    rangeId,
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end,
    serviceName
  } = urlParams;
  const mapFilters = (0, _use_map_filters.useMapFilters)();
  const layerList = (0, _use_layer_list.useLayerList)();
  const [embeddable, setEmbeddable] = (0, _react.useState)();
  const embeddableRoot = (0, _react.useRef)(null);
  const {
    embeddable: embeddablePlugin,
    maps
  } = (0, _use_kibana_services.useKibanaServices)();
  if (!embeddablePlugin) {
    throw new Error('Embeddable start plugin not found');
  }
  const factory = embeddablePlugin.getEmbeddableFactory(_common.MAP_SAVED_OBJECT_TYPE);
  const input = {
    attributes: {
      title: ''
    },
    id: (0, _uuid.v4)(),
    filters: mapFilters,
    viewMode: _public.ViewMode.VIEW,
    isLayerTOCOpen: false,
    query: {
      query: 'transaction.type : "page-load"',
      language: 'kuery'
    },
    ...(start && {
      timeRange: {
        from: new Date(start).toISOString(),
        to: new Date(end).toISOString()
      }
    }),
    hideFilterActions: true
  };
  function renderTooltipContent({
    addFilters,
    closeTooltip,
    features,
    isLocked,
    getLayerName,
    loadFeatureProperties
  }) {
    const props = {
      addFilters,
      closeTooltip,
      isLocked,
      getLayerName,
      loadFeatureProperties
    };
    return /*#__PURE__*/_react.default.createElement(_map_tooltip.MapToolTip, (0, _extends2.default)({}, props, {
      features: features
    }));
  }
  (0, _react.useEffect)(() => {
    if (embeddable != null && serviceName) {
      embeddable.updateInput({
        filters: mapFilters
      });
      embeddable.reload();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [mapFilters]);

  // DateRange updated useEffect
  (0, _react.useEffect)(() => {
    if (embeddable != null && start != null && end != null) {
      const timeRange = {
        from: new Date(start).toISOString(),
        to: new Date(end).toISOString()
      };
      embeddable.updateInput({
        timeRange
      });
      embeddable.reload();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [start, end, rangeId]);
  (0, _react.useEffect)(() => {
    async function setupEmbeddable() {
      if (!factory) {
        throw new Error('Map embeddable not found.');
      }
      const embeddableObject = await factory.create({
        ...input,
        title: 'Visitors by region'
      });
      if (embeddableObject && !(0, _public.isErrorEmbeddable)(embeddableObject)) {
        embeddableObject.setRenderTooltipContent(renderTooltipContent);
        const basemapLayerDescriptor = maps ? await maps.createLayerDescriptors.createBasemapLayerDescriptor() : null;
        if (basemapLayerDescriptor) {
          layerList.unshift(basemapLayerDescriptor);
        }
        await embeddableObject.setLayerList(layerList);
      }
      setEmbeddable(embeddableObject);
    }
    setupEmbeddable();

    // we want this effect to execute exactly once after the component mounts
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // We can only render after embeddable has already initialized
  (0, _react.useEffect)(() => {
    if (embeddableRoot.current && embeddable && serviceName) {
      embeddable.render(embeddableRoot.current);
    }
  }, [embeddable, embeddableRoot, serviceName]);
  return /*#__PURE__*/_react.default.createElement(EmbeddedPanel, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "xpack.ux.regionMap.embeddedPanel",
    className: "embPanel__content",
    ref: embeddableRoot
  }));
}
EmbeddedMapComponent.displayName = 'EmbeddedMap';
const EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);
exports.EmbeddedMap = EmbeddedMap;