"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "createCallApmApi", {
  enumerable: true,
  get: function () {
    return _create_call_apm_api.createCallApmApi;
  }
});
exports.fetchUxOverviewDate = void 0;
exports.hasRumData = hasRumData;
var _public = require("@kbn/data-plugin/public");
var _core_web_vitals_query = require("../../../services/data/core_web_vitals_query");
var _create_call_apm_api = require("../../../services/rest/create_call_apm_api");
var _has_rum_data_query = require("../../../services/data/has_rum_data_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getCoreWebVitalsResponse({
  absoluteTime,
  serviceName,
  dataStartPlugin
}) {
  const dataViewResponse = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/data_view/title', {
    signal: null
  });
  return await esQuery(dataStartPlugin, {
    params: {
      index: dataViewResponse.apmDataViewTitle,
      ...(0, _core_web_vitals_query.coreWebVitalsQuery)(absoluteTime.start, absoluteTime.end, undefined, {
        serviceName: serviceName ? [serviceName] : undefined
      })
    }
  });
}
const CORE_WEB_VITALS_DEFAULTS = {
  coreVitalPages: 0,
  cls: 0,
  fid: 0,
  lcp: 0,
  tbt: 0,
  fcp: 0,
  lcpRanks: _core_web_vitals_query.DEFAULT_RANKS,
  fidRanks: _core_web_vitals_query.DEFAULT_RANKS,
  clsRanks: _core_web_vitals_query.DEFAULT_RANKS
};
const fetchUxOverviewDate = async params => {
  var _transformCoreWebVita;
  const coreWebVitalsResponse = await getCoreWebVitalsResponse(params);
  return {
    coreWebVitals: (_transformCoreWebVita = (0, _core_web_vitals_query.transformCoreWebVitalsResponse)(coreWebVitalsResponse)) !== null && _transformCoreWebVita !== void 0 ? _transformCoreWebVita : CORE_WEB_VITALS_DEFAULTS,
    appLink: `/app/ux?rangeFrom=${params.relativeTime.start}&rangeTo=${params.relativeTime.end}`
  };
};
exports.fetchUxOverviewDate = fetchUxOverviewDate;
async function hasRumData(params) {
  var _params$absoluteTime, _params$absoluteTime2;
  const dataViewResponse = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/data_view/title', {
    signal: null
  });
  const esQueryResponse = await esQuery(params.dataStartPlugin, {
    params: {
      index: dataViewResponse.apmDataViewTitle,
      ...(0, _has_rum_data_query.hasRumDataQuery)({
        start: params === null || params === void 0 ? void 0 : (_params$absoluteTime = params.absoluteTime) === null || _params$absoluteTime === void 0 ? void 0 : _params$absoluteTime.start,
        end: params === null || params === void 0 ? void 0 : (_params$absoluteTime2 = params.absoluteTime) === null || _params$absoluteTime2 === void 0 ? void 0 : _params$absoluteTime2.end
      })
    }
  });
  return (0, _has_rum_data_query.formatHasRumResult)(esQueryResponse, dataViewResponse.apmDataViewTitle);
}
async function esQuery(dataStartPlugin, query) {
  return new Promise((resolve, reject) => {
    const search$ = dataStartPlugin.search.search(query, {
      legacyHitsTotal: false
    }).subscribe({
      next: result => {
        if ((0, _public.isCompleteResponse)(result)) {
          resolve(result.rawResponse);
          search$.unsubscribe();
        }
      },
      error: err => {
        reject(err);
      }
    });
  });
}