"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXMetrics = UXMetrics;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/exploratory-view-plugin/public");
var _translations = require("../translations");
var _key_ux_metrics = require("./key_ux_metrics");
var _use_ux_query = require("../hooks/use_ux_query");
var _csm_shared_context = require("../csm_shared_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _translations2 = require("./translations");
var _use_core_web_vitals_query = require("../../../../hooks/use_core_web_vitals_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UXMetrics() {
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const uxQuery = (0, _use_ux_query.useUxQuery)();
  const {
    data,
    loading: loadingResponse
  } = (0, _use_core_web_vitals_query.useCoreWebVitalsQuery)(uxQuery);
  const loading = loadingResponse !== null && loadingResponse !== void 0 ? loadingResponse : true;
  const {
    sharedData: {
      totalPageViews
    }
  } = (0, _react.useContext)(_csm_shared_context.CsmSharedContext);
  const CoreVitals = (0, _react.useMemo)(() => (0, _public.getCoreVitalsComponent)({
    data,
    totalPageViews,
    loading,
    displayTrafficMetric: true
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [loading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.I18LABELS.metrics, " (", (0, _translations2.getPercentileLabel)(percentile), ")")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_key_ux_metrics.KeyUXMetrics, {
    data: data,
    loading: loading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`,
    style: {
      minHeight: 150
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), CoreVitals)));
}