"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPercentile = UserPercentile;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_P = 50;
function UserPercentile() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const updatePercentile = (0, _react.useCallback)((percentileN, replaceHistory) => {
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)({
        ...(0, _public.toQuery)(history.location.search),
        percentile: percentileN
      })
    };
    if (replaceHistory) {
      history.replace(newLocation);
    } else {
      history.push(newLocation);
    }
  }, [history]);
  (0, _react.useEffect)(() => {
    if (!percentile) {
      updatePercentile(DEFAULT_P, true);
    }
  });
  const options = [{
    value: '50',
    text: _translations.I18LABELS.percentile50thMedian,
    'data-test-subj': 'p50Percentile'
  }, {
    value: '75',
    text: _translations.I18LABELS.percentile75th,
    'data-test-subj': 'p75Percentile'
  }, {
    value: '90',
    text: _translations.I18LABELS.percentile90th,
    'data-test-subj': 'p90Percentile'
  }, {
    value: '95',
    text: _translations.I18LABELS.percentile95th,
    'data-test-subj': 'p95Percentile'
  }, {
    value: '99',
    text: _translations.I18LABELS.percentile99th,
    'data-test-subj': 'p99Percentile'
  }];
  const onChange = val => {
    updatePercentile(Number(val));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    prepend: _translations.I18LABELS.percentile,
    "data-test-subj": "uxPercentileSelect",
    options: options,
    onChange: evt => onChange(evt.target.value)
  });
}