"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlSearch = void 0;
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _use_ux_query = require("../../hooks/use_ux_query");
var _use_url_params = require("../../../../../context/url_params_context/use_url_params");
var _use_data_view = require("../../local_uifilters/use_data_view");
var _url_search_query = require("../../../../../services/data/url_search_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUrlSearch = ({
  popoverIsOpen,
  query
}) => {
  const uxQuery = (0, _use_ux_query.useUxQuery)();
  const {
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    transactionUrl,
    transactionUrlExcluded,
    ...restFilters
  } = uxUiFilters;
  const [searchValue, setSearchValue] = (0, _react.useState)(query !== null && query !== void 0 ? query : '');
  (0, _useDebounce.default)(() => {
    setSearchValue(query);
  }, 250, [query]);
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: asyncSearchResult,
    loading
  } = (0, _public.useEsSearch)({
    // when `index` is undefined, the hook will not send a request,
    // so we pass this to ensure the search values load lazily
    index: uxQuery && popoverIsOpen ? dataViewTitle : undefined,
    ...(0, _url_search_query.urlSearchQuery)(restFilters, uxQuery, searchValue)
  }, [dataViewTitle, popoverIsOpen, uxQuery, searchValue], {
    name: 'UX_URL_SEARCH'
  });
  const data = (0, _react.useMemo)(() => {
    var _asyncSearchResult$ag, _uxQuery$percentile, _urls$buckets;
    if (!asyncSearchResult) return asyncSearchResult;
    const {
      urls,
      totalUrls
    } = (_asyncSearchResult$ag = asyncSearchResult.aggregations) !== null && _asyncSearchResult$ag !== void 0 ? _asyncSearchResult$ag : {};
    const pkey = Number((_uxQuery$percentile = uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.percentile) !== null && _uxQuery$percentile !== void 0 ? _uxQuery$percentile : 0).toFixed(1);
    return {
      total: (totalUrls === null || totalUrls === void 0 ? void 0 : totalUrls.value) || 0,
      items: ((_urls$buckets = urls === null || urls === void 0 ? void 0 : urls.buckets) !== null && _urls$buckets !== void 0 ? _urls$buckets : []).map(bucket => {
        var _bucket$medianPLD$val;
        return {
          url: bucket.key,
          count: bucket.doc_count,
          pld: (_bucket$medianPLD$val = bucket.medianPLD.values[pkey]) !== null && _bucket$medianPLD$val !== void 0 ? _bucket$medianPLD$val : 0
        };
      })
    };
  }, [asyncSearchResult, uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.percentile]);
  return {
    data,
    loading
  };
};
exports.useUrlSearch = useUrlSearch;