"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URLFilter = URLFilter;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _public = require("@kbn/observability-plugin/public");
var _url_search = require("./url_search");
var _helpers = require("../../../../context/url_params_context/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function URLFilter() {
  const history = (0, _reactRouterDom.useHistory)();
  const setFilterValue = (0, _react.useCallback)((value, excludedValue) => {
    const name = 'transactionUrl';
    const nameExcluded = 'transactionUrlExcluded';
    const search = (0, _lodash.omit)((0, _public.toQuery)(history.location.search), name);
    history.push({
      ...history.location,
      search: (0, _public.fromQuery)((0, _helpers.removeUndefinedProps)({
        ...search,
        [name]: value !== null && value !== void 0 && value.length ? value.join(',') : undefined,
        [nameExcluded]: excludedValue !== null && excludedValue !== void 0 && excludedValue.length ? excludedValue.join(',') : undefined
      }))
    });
  }, [history]);
  const updateSearchTerm = (0, _react.useCallback)(searchTermN => {
    const newQuery = {
      ...(0, _public.toQuery)(history.location.search),
      searchTerm: searchTermN || undefined
    };
    if (!searchTermN) {
      delete newQuery.searchTerm;
    }
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)(newQuery)
    };
    history.push(newLocation);
  }, [history]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-cy": "csmUrlFilter"
  }, /*#__PURE__*/_react.default.createElement(_url_search.URLSearch, {
    onChange: setFilterValue,
    updateSearchTerm: updateSearchTerm
  }));
}