"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARD_LABEL = void 0;
exports.RumHome = RumHome;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _web_application_select = require("./panels/web_application_select");
var _user_percentile = require("./user_percentile");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_has_rum_data = require("./hooks/use_has_rum_data");
var _rum_datepicker = require("./rum_datepicker");
var _empty_state_loading = require("./empty_state_loading");
var _use_kibana_services = require("../../../hooks/use_kibana_services");
var _environment_filter = require("./environment_filter");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARD_LABEL = _i18n.i18n.translate('xpack.ux.title', {
  defaultMessage: 'Dashboard'
});
exports.DASHBOARD_LABEL = DASHBOARD_LABEL;
function RumHome() {
  const {
    docLinks,
    http,
    observabilityShared
  } = (0, _use_kibana_services.useKibanaServices)();
  const PageTemplateComponent = observabilityShared.navigation.PageTemplate;
  const {
    hasData,
    loading: isLoading
  } = (0, _use_has_rum_data.useHasRumData)();
  const noDataConfig = !hasData ? {
    solution: _i18n.i18n.translate('xpack.ux.overview.solutionName', {
      defaultMessage: 'Observability'
    }),
    action: {
      elasticAgent: {
        title: _i18n.i18n.translate('xpack.ux.overview.beatsCard.title', {
          defaultMessage: 'Add RUM data'
        }),
        description: _i18n.i18n.translate('xpack.ux.overview.beatsCard.description', {
          defaultMessage: 'Enable RUM with the APM agent to collect user experience data.'
        }),
        href: http.basePath.prepend(`/app/home#/tutorial/apm`)
      }
    },
    docsLink: docLinks.links.observability.guide
  } : undefined;
  return /*#__PURE__*/_react.default.createElement(PageTemplateComponent, {
    noDataConfig: isLoading ? undefined : noDataConfig,
    pageHeader: {
      children: /*#__PURE__*/_react.default.createElement(PageHeader, null)
    },
    isPageDataLoaded: isLoading === false,
    isEmptyState: isLoading
  }, isLoading && /*#__PURE__*/_react.default.createElement(_empty_state_loading.EmptyStateLoading, null), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      visibility: isLoading ? 'hidden' : 'initial'
    }
  }, /*#__PURE__*/_react.default.createElement(_.RumOverview, null)));
}
function PageHeader() {
  const sizes = (0, _use_breakpoints.useBreakpoints)();
  const datePickerStyle = sizes.isMedium ? {} : {
    maxWidth: '70%'
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", {
    className: "eui-textNoWrap"
  }, DASHBOARD_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignItems: 'flex-end',
      ...datePickerStyle
    }
  }, /*#__PURE__*/_react.default.createElement(_rum_datepicker.RumDatePicker, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_web_application_select.WebApplicationSelect, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_percentile.UserPercentile, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_environment_filter.UxEnvironmentFilter, null))));
}