"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RumDashboard = RumDashboard;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _translations = require("./translations");
var _ux_metrics = require("./ux_metrics");
var _impactful_metrics = require("./impactful_metrics");
var _page_load_and_views = require("./panels/page_load_and_views");
var _visitor_breakdowns = require("./panels/visitor_breakdowns");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _client_metrics = require("./client_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RumDashboard() {
  const {
    isSmall
  } = (0, _use_breakpoints.useBreakpoints)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isSmall ? 'row' : 'column',
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_client_metrics.ClientMetrics, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ux_metrics.UXMetrics, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_page_load_and_views.PageLoadAndViews, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.LoadWhenInView, {
    initialHeight: 300,
    placeholderTitle: _translations.I18LABELS.pageLoadDurationByRegion
  }, /*#__PURE__*/_react.default.createElement(_visitor_breakdowns.VisitorBreakdownsPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.LoadWhenInView, {
    initialHeight: 300,
    placeholderTitle: _translations.I18LABELS.jsErrors
  }, /*#__PURE__*/_react.default.createElement(_impactful_metrics.ImpactfulMetrics, null))));
}