"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetPercentileZoom = ResetPercentileZoom;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ResetPercentileZoom({
  percentileRange,
  setPercentileRange
}) {
  const isDisabled = percentileRange.min === null && percentileRange.max === null;
  const onClick = () => {
    setPercentileRange({
      min: null,
      max: null
    });
  };
  return !isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "inspect",
    size: "s",
    "aria-label": _translations.I18LABELS.resetZoom,
    onClick: onClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "uxResetPercentileZoomButton",
    iconType: "inspect",
    size: "s",
    onClick: onClick
  }, _translations.I18LABELS.resetZoom))) : null;
}