"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSErrors = JSErrors;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_js_errors_query = require("../../../../hooks/use_js_errors_query");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _translations = require("../translations");
var _csm_shared_context = require("../csm_shared_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JSErrors() {
  var _data$totalErrors, _data$items, _data$totalErrorGroup;
  const {
    http
  } = (0, _use_kibana_services.useKibanaServices)();
  const basePath = http.basePath.get();
  const {
    urlParams: {
      serviceName
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 5
  });
  const {
    data,
    loading
  } = (0, _use_js_errors_query.useJsErrorsQuery)(pagination);
  const {
    sharedData: {
      totalPageViews
    }
  } = (0, _react.useContext)(_csm_shared_context.CsmSharedContext);
  const cols = [{
    field: 'errorMessage',
    name: _translations.I18LABELS.errorMessage,
    render: (errorMessage, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "uxColsLink",
      href: `${basePath}/app/apm/services/${serviceName}/errors/${item.errorGroupId}`
    }, errorMessage)
  }, {
    name: _translations.I18LABELS.impactedPageLoads,
    field: 'count',
    align: 'right',
    render: count => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ux.jsErrors.percent",
      defaultMessage: "{pageLoadPercent} %",
      values: {
        pageLoadPercent: (count / totalPageViews * 100).toFixed(1)
      }
    })
  }];
  const onTableChange = ({
    page
  }) => {
    setPagination({
      pageIndex: page.index,
      pageSize: page.size
    });
  };
  const totalErrors = (_data$totalErrors = data === null || data === void 0 ? void 0 : data.totalErrors) !== null && _data$totalErrors !== void 0 ? _data$totalErrors : 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.I18LABELS.jsErrors)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxJsErrorsTotal',
    titleSize: "s",
    title: totalErrors < 1000 ? totalErrors : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: totalErrors
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _numeral.default)(totalErrors).format('0 a'))),
    description: _translations.I18LABELS.totalErrors,
    isLoading: !!loading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": 'uxJsErrorTable',
    loading: !!loading,
    error: !loading && !data ? _i18n.i18n.translate('xpack.ux.jsErrorsTable.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    responsive: false,
    compressed: true,
    columns: cols,
    items: (_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : [],
    onChange: onTableChange,
    pagination: {
      ...pagination,
      totalItemCount: (_data$totalErrorGroup = data === null || data === void 0 ? void 0 : data.totalErrorGroups) !== null && _data$totalErrorGroup !== void 0 ? _data$totalErrorGroup : 0
    }
  }));
}