"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasRumData = useHasRumData;
var _public = require("@kbn/observability-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _react = require("react");
var _has_rum_data_query = require("../../../../services/data/has_rum_data_query");
var _use_data_view = require("../local_uifilters/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useHasRumData() {
  const [hasData, setHasData] = (0, _useLocalStorage.default)('uxAppHasDataBoolean', false);
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: response,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _has_rum_data_query.hasRumDataQuery)({})
  }, [dataViewTitle], {
    name: 'UXHasRumData'
  });
  (0, _react.useEffect)(() => {
    if (response) {
      const {
        hasData: hasDataN
      } = (0, _has_rum_data_query.formatHasRumResult)(response, dataViewTitle);
      setHasData(hasDataN);
    }
  }, [dataViewTitle, response, setHasData]);
  if (!response) return {
    loading,
    hasData
  };
  return {
    hasData: (0, _has_rum_data_query.formatHasRumResult)(response, dataViewTitle).hasData,
    loading
  };
}