"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBreakdownChart = VisitorBreakdownChart;
exports.VisitorBreakdownMetric = void 0;
exports.getVisitorBreakdownLensAttributes = getVisitorBreakdownLensAttributes;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _uuid = require("uuid");
var _transaction_types = require("../../../../../common/transaction_types");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _get_es_filter = require("../../../../services/data/get_es_filter");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUCKET_SIZE = 9;
let VisitorBreakdownMetric;
exports.VisitorBreakdownMetric = VisitorBreakdownMetric;
(function (VisitorBreakdownMetric) {
  VisitorBreakdownMetric["OS_BREAKDOWN"] = "user_agent.os.name";
  VisitorBreakdownMetric["UA_BREAKDOWN"] = "user_agent.name";
})(VisitorBreakdownMetric || (exports.VisitorBreakdownMetric = VisitorBreakdownMetric = {}));
function VisitorBreakdownChart({
  start,
  end,
  onFilter,
  uiFilters,
  urlQuery,
  metric,
  dataView
}) {
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const LensEmbeddableComponent = kibana.lens.EmbeddableComponent;
  const [localDataViewId] = (0, _react.useState)((0, _uuid.v4)());
  const lensAttributes = (0, _react.useMemo)(() => getVisitorBreakdownLensAttributes({
    uiFilters,
    urlQuery,
    metric,
    dataView,
    localDataViewId
  }), [uiFilters, urlQuery, metric, dataView, localDataViewId]);
  const filterHandler = (0, _react.useCallback)(event => {
    onFilter(metric, event);
  }, [onFilter, metric]);
  if (!LensEmbeddableComponent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "No lens component");
  }
  return /*#__PURE__*/_react.default.createElement(LensEmbeddableComponent, {
    id: `ux-visitor-breakdown-${metric.replaceAll('.', '-')}`,
    hidePanelTitles: true,
    withDefaultActions: true,
    style: {
      minHeight: '250px',
      height: '100%'
    },
    attributes: lensAttributes,
    timeRange: {
      from: start !== null && start !== void 0 ? start : '',
      to: end !== null && end !== void 0 ? end : ''
    },
    viewMode: _public.ViewMode.VIEW,
    onFilter: filterHandler
  });
}
const visConfig = {
  layers: [{
    layerId: 'layer1',
    primaryGroups: ['col1'],
    metrics: ['col2'],
    categoryDisplay: 'default',
    legendDisplay: 'hide',
    numberDisplay: 'percent',
    showValuesInLegend: true,
    nestedLegend: false,
    layerType: 'data'
  }],
  shape: 'pie'
};
function getVisitorBreakdownLensAttributes({
  uiFilters,
  urlQuery,
  metric,
  dataView,
  localDataViewId
}) {
  const localDataView = dataView.toSpec(false);
  localDataView.id = localDataViewId;
  const dataLayer = {
    incompleteColumns: {},
    columnOrder: ['col1', 'col2'],
    columns: {
      col1: {
        label: `Top ${BUCKET_SIZE} values of ${metric}`,
        dataType: 'string',
        operationType: 'terms',
        scale: 'ordinal',
        sourceField: metric,
        isBucketed: true,
        params: {
          size: BUCKET_SIZE,
          orderBy: {
            type: 'column',
            columnId: 'col2'
          },
          orderDirection: 'desc',
          otherBucket: true,
          parentFormat: {
            id: 'terms'
          }
        }
      },
      col2: {
        label: 'Count of records',
        dataType: 'number',
        operationType: 'count',
        isBucketed: false,
        scale: 'ratio',
        sourceField: '___records___',
        params: {
          emptyAsNull: true
        }
      }
    }
  };
  return {
    visualizationType: 'lnsPie',
    title: `ux-visitor-breakdown-${metric}`,
    references: [],
    state: {
      internalReferences: [{
        id: localDataView.id,
        name: 'indexpattern-datasource-current-indexpattern',
        type: 'index-pattern'
      }, {
        id: localDataView.id,
        name: 'indexpattern-datasource-layer-layer1',
        type: 'index-pattern'
      }],
      adHocDataViews: {
        [localDataView.id]: localDataView
      },
      datasourceStates: {
        formBased: {
          layers: {
            layer1: dataLayer
          }
        }
      },
      filters: [{
        meta: {},
        query: {
          bool: {
            filter: [{
              term: {
                [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
              }
            }, {
              terms: {
                [_elasticsearch_fieldnames.PROCESSOR_EVENT]: [_common.ProcessorEvent.transaction]
              }
            }, {
              exists: {
                field: 'transaction.marks.navigationTiming.fetchStart'
              }
            }, ...(0, _get_es_filter.getEsFilter)(uiFilters), ...(urlQuery ? [{
              wildcard: {
                'url.full': `*${urlQuery}*`
              }
            }] : [])],
            must_not: [...(0, _get_es_filter.getEsFilter)(uiFilters, true)]
          }
        }
      }],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: visConfig
    }
  };
}