"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpViewAttributes = void 0;
var _public = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExpViewAttributes = () => {
  var _uxUiFilters$serviceN;
  const {
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end
  } = urlParams;
  const reportDefinitions = {
    [_elasticsearch_fieldnames.SERVICE_ENVIRONMENT]: !(uxUiFilters !== null && uxUiFilters !== void 0 && uxUiFilters.environment) || uxUiFilters.environment === _environment_filter_values.ENVIRONMENT_ALL.value ? [_public.ALL_VALUES_SELECTED] : [uxUiFilters.environment],
    [_elasticsearch_fieldnames.SERVICE_NAME]: (_uxUiFilters$serviceN = uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters.serviceName) !== null && _uxUiFilters$serviceN !== void 0 ? _uxUiFilters$serviceN : [_public.ALL_VALUES_SELECTED]
  };
  return {
    reportDefinitions,
    time: {
      from: start !== null && start !== void 0 ? start : '',
      to: end !== null && end !== void 0 ? end : ''
    }
  };
};
exports.useExpViewAttributes = useExpViewAttributes;