"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeAssistantUIPlugin = void 0;
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _i18n = require("@kbn/i18n");
var _api = require("./application/lib/api");
var _breadcrumbs = require("./application/lib/breadcrumbs");
var _ui_metric = require("./application/lib/ui_metric");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class UpgradeAssistantUIPlugin {
  constructor(ctx) {
    this.ctx = ctx;
  }
  setup(coreSetup, {
    management,
    cloud,
    share,
    usageCollection
  }) {
    const {
      featureSet,
      ui: {
        enabled: isUpgradeAssistantUiEnabled
      }
    } = this.ctx.config.get();
    if (isUpgradeAssistantUiEnabled) {
      const appRegistrar = management.sections.section.stack;
      const kibanaVersion = new _semver.default(this.ctx.env.packageInfo.version);
      const kibanaVersionInfo = {
        currentMajor: kibanaVersion.major,
        prevMajor: kibanaVersion.major - 1,
        nextMajor: kibanaVersion.major + 1
      };
      const pluginName = _i18n.i18n.translate('xpack.upgradeAssistant.appTitle', {
        defaultMessage: 'Upgrade Assistant'
      });
      if (usageCollection) {
        _ui_metric.uiMetricService.setup(usageCollection);
      }
      appRegistrar.registerApp({
        id: 'upgrade_assistant',
        title: pluginName,
        order: 1,
        async mount(params) {
          const [coreStart, {
            data,
            ...plugins
          }] = await coreSetup.getStartServices();
          const {
            chrome: {
              docTitle
            }
          } = coreStart;
          docTitle.change(pluginName);
          const appDependencies = {
            featureSet,
            kibanaVersionInfo,
            plugins: {
              cloud,
              share,
              // Infra plugin doesnt export anything as a public interface. So the only
              // way we have at this stage for checking if the plugin is available or not
              // is by checking if the startServices has the `infra` key.
              infra: plugins.hasOwnProperty('infra') ? {} : undefined
            },
            services: {
              core: coreStart,
              data,
              history: params.history,
              api: _api.apiService,
              breadcrumbs: _breadcrumbs.breadcrumbService
            },
            theme$: params.theme$
          };
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
          const unmountAppCallback = mountManagementSection(params, appDependencies);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
    }
  }
  start() {}
  stop() {}
}
exports.UpgradeAssistantUIPlugin = UpgradeAssistantUIPlugin;