"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _app = require("./app");
var _api = require("./lib/api");
var _breadcrumbs = require("./lib/breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mountManagementSection(params, dependencies) {
  const {
    element,
    setBreadcrumbs
  } = params;
  _api.apiService.setup(dependencies.services.core.http);
  _breadcrumbs.breadcrumbService.setup(setBreadcrumbs);
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_app.RootComponent, dependencies), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
}