"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveLogsCheckpoint = exports.loadLogsCheckpoint = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETTING_ID = 'kibana.upgradeAssistant.lastCheckpoint';
const localStorage = new _shared_imports.Storage(window.localStorage);
const loadLogsCheckpoint = () => {
  const storedValue = (0, _momentTimezone.default)(localStorage.get(SETTING_ID));
  if (storedValue.isValid()) {
    return storedValue.toISOString();
  }
  const now = (0, _momentTimezone.default)().toISOString();
  localStorage.set(SETTING_ID, now);
  return now;
};
exports.loadLogsCheckpoint = loadLogsCheckpoint;
const saveLogsCheckpoint = value => {
  localStorage.set(SETTING_ID, value);
};
exports.saveLogsCheckpoint = saveLogsCheckpoint;